<?php
$php_minimum = '5.1'; // User's PHP must be equal or newer to this version.

if ( version_compare( PHP_VERSION, $php_minimum ) < 0 ) {
	die( 'ERROR #9013. See <a href="http://ithemes.com/codex/page/BackupBuddy:_Error_Codes#9013">this codex page for details</a>. Sorry! PHP version ' . $php_minimum . ' or newer is required for BackupBuddy to properly run. You are running PHP version ' . PHP_VERSION . '.' );
}


define( 'ABSPATH', dirname( __FILE__ ) . '/' );
define( 'PB_BB_VERSION', '3.3.0.1' );
define( 'PB_PASSWORD', 'f00bdfd475bb4661c50caee90be7873d' );


// Try to put an index.htm file in place during import to help prevent against file browsing. Only do if not a defined step OR a non-numeric defined step OR a defined numeric step < 5.
if (
	( ! isset( $_GET['step'] ) )
	||
	( isset( $_GET['step'] ) && !is_numeric( $_GET['step'] ) )
	||
	( isset( $_GET['step'] ) && is_numeric( $_GET['step'] ) && ( $_GET['step'] < 5 ) )
	)
{
	if ( ! file_exists( ABSPATH . 'index.htm' ) ) {
		@file_put_contents( ABSPATH . 'index.htm', '<html></html>' );
	}
}


// Unpack importbuddy files into importbuddy directory.
if ( !file_exists( ABSPATH . 'importbuddy' ) || ( ( count( $_GET ) == 0 ) && ( count( $_POST ) == 0 ) ) ) {
	$unpack_importbuddy = true;
	if ( file_exists( ABSPATH . 'importbuddy' ) ) { // ImportBuddy directory already exists. We may need to re-unpack it if this file has been updated since.
		$signature = @file_get_contents( ABSPATH . 'importbuddy/_signature.php' );
		$signature = trim( str_replace( '<?php die(); ?>', '', $signature ) );
		if ( md5( PB_BB_VERSION . PB_PASSWORD ) != $signature ) { // Signature mismatch. We will need to delete and unpack again to update.
			echo '<!-- unlinking existing importbuddy directory. -->';
			recursive_unlink( ABSPATH . 'importbuddy' );
		} else {
			$unpack_importbuddy = false;
		}
	}
	if ( true === $unpack_importbuddy ) {
		unpack_importbuddy();
		@file_put_contents( ABSPATH . 'importbuddy/_signature.php', '<?php die(); ?>' . md5( PB_BB_VERSION . PB_PASSWORD ) ); // Create a hash of this ImportBuddy version & password. On accessing importbuddy.php's authentication page all importbuddy files will be freshly unpacked if the importbuddy.php version and/or password mismatches to allow users to just replace importbuddy.php to upgrade ImportBuddy or password.
	}
}



date_default_timezone_set( @date_default_timezone_get() ); // Prevents date() from throwing a warning if the default timezone has not been set.


if ( isset( $_GET['api'] ) && ( $_GET['api'] != '' ) ) { // API ACCESS
	if ( $_GET['api'] == 'ping' ) {
		die( 'pong' );
	} else {
		die( 'Unknown API access action.' );
	}
} else { // NORMAL ACCESS.
	if ( !file_exists( ABSPATH . 'importbuddy/init.php' ) ) {
		die( 'Error: Unable to find file `' . ABSPATH . 'importbuddy/init.php`. Make sure that you downloaded this script from within BackupBuddy. Copying importbuddy files from inside the plugin directory is not sufficient as many file additions are made on demand.' );
	} else {
		require_once( ABSPATH . 'importbuddy/init.php' );
	}
}



function recursive_unlink( $path ) {
  return is_file($path)?
    @unlink($path):
    array_map('recursive_unlink',glob($path.'/*'))==@rmdir($path);
}



/**
*	unpack_importbuddy()
*
*	Unpacks required files encoded in importbuddy.php into stand-alone files.
*
*	@return		null
*/
function unpack_importbuddy() {
	if ( !is_writable( ABSPATH ) ) {
		echo 'Error #224834. This directory is not write enabled. Please verify write permissions to continue.';
		die();
	} else {
		$unpack_file = '';
		
		// Make sure the file is complete and contains all the packed data to the end.
		if ( false === strpos( file_get_contents( ABSPATH . 'importbuddy.php' ), '###PACKDATA' . ',END' ) ) { // Concat here so we don't false positive on this line when searching.
			die( 'ERROR: It appears your importbuddy.php file is incomplete.  It may have not finished uploaded completely.  Please try re-downloading the script from within BackupBuddy in WordPress (do not just copy the file from the plugin directory) and re-uploading it.' );
		}
		
		$handle = @fopen( ABSPATH . 'importbuddy.php', 'r' );
		if ( $handle ) {
			while ( ( $buffer = fgets( $handle ) ) !== false ) {
				if ( substr( $buffer, 0, 11 ) == '###PACKDATA' ) {
					$packdata_commands = explode( ',', trim( $buffer ) );
					array_shift( $packdata_commands );
					
					if ( $packdata_commands[0] == 'BEGIN' ) {
						// Start packed data.
					} elseif ( $packdata_commands[0] == 'FILE_START' ) {
						$unpack_file = $packdata_commands[2];
					} elseif ( $packdata_commands[0] == 'FILE_END' ) {
						$unpack_file = '';
					} elseif ( $packdata_commands[0] == 'END' ) {
						return;
					}
				} else {
					if ( $unpack_file != '' ) {
						if ( !is_dir( dirname( ABSPATH . $unpack_file ) ) ) {
							$mkdir_result = mkdir( dirname( ABSPATH . $unpack_file ), 0777, true ); // second param makes recursive.
							if ( $mkdir_result === false ) {
								echo 'Error #54455. Unable to mkdir `' . dirname( ABSPATH . $unpack_file ) . '`<br>';
							}
						}
						$fileput_result = file_put_contents( ABSPATH . $unpack_file, trim( base64_decode( $buffer ) ) );
						if ( $fileput_result === false ) {
							echo 'Error #65656. Unable to put file contents to `' . ABSPATH . $unpack_file . '`.<br>';
						}
					}
				}
			}
			if ( !feof( $handle ) ) {
				echo "Error: unexpected fgets() fail.<br>";
			}
			fclose( $handle );
		} else {
			echo 'ERROR #54455: Unable to open importbuddy.php file for reading in packaged data.<br>';
		}
	}
}
die();
?>
<?php /*
###PACKDATA,BEGIN
###PACKDATA,FILE_START,/_importbuddy/importbuddy/history.txt,importbuddy/history.txt
My4wLjAgLSAyMDEyLTAxLTA2IC0gRHVzdGluIEJvbHRvbgo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/history.txt,importbuddy/history.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/history_archived.txt,importbuddy/history_archived.txt
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/history_archived.txt,importbuddy/history_archived.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/index.php,importbuddy/index.php
PD9waHAKLy8gU2lsZW5jZSBpcyBnb2xkZW4uCj8+
###PACKDATA,FILE_END,/_importbuddy/importbuddy/index.php,importbuddy/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init.php,importbuddy/init.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init.php,importbuddy/init.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init_admin.php,importbuddy/init_admin.php
PD9waHAKcGJfYmFja3VwYnVkZHk6OmxvYWQoKTsKCi8vICoqKioqKioqKiogQUNUSU9OUyAoYWRtaW4pICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBBSkFYIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIERBU0hCT0FSRCAoYWRtaW4pICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBGSUxURVJTIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIFBBR0VTIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIExJQlJBUklFUyAmIENMQVNTRVMgKGFkbWluKSAqKioqKioqKioqCnJlcXVpcmVfb25jZSggJ2NsYXNzZXMvY29yZS5waHAnICk7CnBiX2JhY2t1cGJ1ZGR5OjokY2xhc3Nlc1snY29yZSddID0gbmV3IHBiX2JhY2t1cGJ1ZGR5X2NvcmUoKTsKCnJlcXVpcmVfb25jZSggJ2NsYXNzZXMvaW1wb3J0LnBocCcgKTsKcGJfYmFja3VwYnVkZHk6OiRjbGFzc2VzWydpbXBvcnQnXSA9IG5ldyBwYl9iYWNrdXBidWRkeV9pbXBvcnQoKTsKCgovLyAqKioqKioqKioqIE9USEVSIChhZG1pbikgKioqKioqKioqKgoKCgo/Pg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init_admin.php,importbuddy/init_admin.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init_global.php,importbuddy/init_global.php
PD9waHAKCmlmICggcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdkaXNwbGF5X21vZGUnICkgPT0gJ2VtYmVkJyApIHsKCXBiX2JhY2t1cGJ1ZGR5Ojokb3B0aW9uc1snZGlzcGxheV9tb2RlJ10gPSAnZW1iZWQnOwoJcGJfYmFja3VwYnVkZHk6OnNhdmUoKTsKfQoKLy8gKioqKioqKioqKiBBQ1RJT05TIChnbG9iYWwpICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBBSkFYIChnbG9iYWwpICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBDUk9OIChnbG9iYWwpICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBGSUxURVJTIChnbG9iYWwpICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBXSURHRVRTIChnbG9iYWwpICoqKioqKioqKioKCgoKPz4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init_global.php,importbuddy/init_global.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init_public.php,importbuddy/init_public.php
PD9waHAKCgoKLy8gKioqKioqKioqKiBBQ1RJT05TIChwdWJsaWMpICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBBSkFYIChwdWJsaWMpICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBGSUxURVJTIChwdWJsaWMpICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBTSE9SVENPREVTIChwdWJsaWMpICoqKioqKioqKioKCgoKPz4K
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init_public.php,importbuddy/init_public.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/license.txt,importbuddy/license.txt
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/license.txt,importbuddy/license.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/readme.txt,importbuddy/readme.txt
ICogV2Vic2l0ZTogaHR0cDovL3BsdWdpbmJ1ZGR5LmNvbQogKgogKiBJbnN0YWxsYXRpb246CiAqIAogKiAxLiBEb3dubG9hZCBhbmQgdW56aXAgdGhlIGxhdGVzdCByZWxlYXNlIHppcCBmaWxlCiAqIDIuIElmIHlvdSB1c2UgdGhlIFdvcmRQcmVzcyBwbHVnaW4gdXBsb2FkZXIgdG8gaW5zdGFsbCB0aGlzIHBsdWdpbiBza2lwIHRvIHN0ZXAgNC4KICogMy4gVXBsb2FkIHRoZSBlbnRpcmUgcGx1Z2luIGRpcmVjdG9yeSB0byB5b3VyIGAvd3AtY29udGVudC9wbHVnaW5zL2AgZGlyZWN0b3J5CiAqIDQuIEFjdGl2YXRlIHRoZSBwbHVnaW4gdGhyb3VnaCB0aGUgJ1BsdWdpbnMnIG1lbnUgaW4gV29yZFByZXNzIEFkbWluaXN0cmF0aW9uCiAqIAogKiBVc2FnZToKICogCiAqIDEuIE5hdmlnYXRlIHRvIHRoZSBuZXcgbWVudSBmb3IgdGhpcyBwbHVnaW4gaW4gdGhlIFdvcmRwcmVzcyBBZG1pbmlzdHJhdGlvbiBQYW5lbAogKiAyLiBTZWxlY3QgJ0dldHRpbmcgU3RhcnRlZCcgZm9yIGluc3RydWN0aW9ucyBhbmQgYWRkaXRpb25hbCBpbmZvcm1hdGlvbi4KICo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/readme.txt,importbuddy/readme.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/auth.php,importbuddy/classes/auth.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/auth.php,importbuddy/classes/auth.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax.php,importbuddy/controllers/ajax.php
PD9waHAKY2xhc3MgcGJfYmFja3VwYnVkZHlfYWpheCBleHRlbmRzIHBiX2JhY2t1cGJ1ZGR5X2FqYXhjb3JlIHsKfQo/Pg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax.php,importbuddy/controllers/ajax.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/css/style.css,importbuddy/css/style.css
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/css/style.css,importbuddy/css/style.css
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/bb-logo.png,importbuddy/images/bb-logo.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/bb-logo.png,importbuddy/images/bb-logo.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/bluebutton.jpg,importbuddy/images/bluebutton.jpg
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/bluebutton.jpg,importbuddy/images/bluebutton.jpg
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/bullet_error.png,importbuddy/images/bullet_error.png
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAhlJREFUeNrEk7tuE0EUhv/ZC7aBOJItItkoOGBjJSkR4REsFyBEkVQUEBcoDQ0SJQ15ApooRVJQJi+AoKFDSCCiiODEBmyMkIXiS3bjy3pn5gyzhgY2XQr+0ezsnjn7aeb8M0wphdPIwCllBQ/1pAQWoJiRBNGiMuxl2HZeKQk5HFao720S8e3RcNj2PR9Tz1/9DfijGXBa45OJIkulYQoPjOmoGV2gem1B/mzc1l8rutdP2kJCCVrnqemilcvBdA7BJpNg8SSsbhPR2TmwS/kiSVoPckMA8vmSP5EoWOkU8Ok95Oc94OY94NZ9+OUyxM47xKYzYMl0QXKxFAJI0ygZqYtA8zvE0RGUGfk9Gzik32WrDfGtjlgmC2kYpRBAmeasFbUhfjR0IW0QJx2kcYIcCZCO+bUaDDs6zg25IIWEkgTF9ah/VkIHR6PAFQ1Tek73oEntis4JAfhxb9/s+deNC2mISgWKWZDPVmFwoRkGRH+AM9mr4EMPfq+3H9qC7zgbg+oBWGoGiMYhXBfmo6dgj1fhtVzgXBxm5jK65R34x85GaAUE2hrUq3dwNlY4f+0GWO0LnIclXUNCZG4e9pUcOge76FZ2X+rlbYUAWh1J8kH3w9s177BVnMjOI5KYGpvAJUfzzWs41Y8vdLVWmGF1TgIEqhOJu25lb9FtfF1mlpVXROOj7PfdTQ3b1uVo/3sX2H+/jb8EGAB6SgK2ePksLgAAAABJRU5ErkJggg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/bullet_error.png,importbuddy/images/bullet_error.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/bullet_go.png,importbuddy/images/bullet_go.png
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAEsSURBVDjLY/j//z8DJZhhmBuQvdj8a+p8w//xc3U5yTIgeb7h18bNUf/DZ2j8958qz0nQgPyltv9zF5v/TV9o/Ddxrv7fmvWh/1ednvi/ZLX/f9d+8b+23YI8eA0AOvn/hnPT/q89OwWsccXpCf8n7Cn5v/B41/+MpW7/TdvZ/+o2M/LjNADoZLDmvl35/zt3ZP9v3Zb2v2Fz4v+mren/Zxxq/h+zwOa/aj3DH5wGRM/W/L/y1IT/S0/0/l94rOv/vKMdQEOy/k8/1PQ/banHf8VahlfSlQwGOA0InK74z3Oi9D/nftF/1t38/+LmW/2fdrDhf9Jit//ytQzPJSsZtEiKBe1mxq/xC53/y1czPAFqVic5GoFO/ipXzfxftJJBkeyUKFzOwDm48wIAh5XH+g7drOwAAAAASUVORK5CYII=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/bullet_go.png,importbuddy/images/bullet_go.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/button-grad.png,importbuddy/images/button-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAeCAYAAADkftS9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAACF0RVh0U29mdHdhcmUATWFjcm9tZWRpYSBGaXJld29ya3MgNC4w6iYndQAAABZ0RVh0Q3JlYXRpb24gVGltZQAxMS8xNy8wONpsdXEAAABGSURBVHicY9Ts2fWfAQ2wMPzHEGNg+f//H6Ygwz9sgthU/sdmJlbtlFpEgpOwWoTszv+Dz0lUtOg/ukoSfATT+5+gSkxBAOqCS3dTeDKPAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/button-grad.png,importbuddy/images/button-grad.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/collapsed.gif,importbuddy/images/collapsed.gif
R0lGODlhBgAHALMKAM7Ozr6+vq6urp6enoWFhaampt7e3u/v742NjX19ff///wAAAAAAAAAAAAAAAAAAACH5BAEAAAoALAAAAAAGAAcAAAQVEAFFVUrD0HvF4RfCEYGVFAeFaFUEADs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/collapsed.gif,importbuddy/images/collapsed.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/expanded.gif,importbuddy/images/expanded.gif
R0lGODlhBwAGALMKAM7Ozr6+vq6urp6enoWFhaampt7e3u/v742NjX19ff///wAAAAAAAAAAAAAAAAAAACH5BAEAAAoALAAAAAAHAAYAAAQWEKU5kaETqEKHUgcxGZ8SJEL5IccXAQA7
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/expanded.gif,importbuddy/images/expanded.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/gray-grad.png,importbuddy/images/gray-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAfCAIAAACgQJBPAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAAsSAAALEgHS3X78AAAAIXRFWHRTb2Z0d2FyZQBNYWNyb21lZGlhIEZpcmV3b3JrcyA0LjDqJid1AAAAFnRFWHRDcmVhdGlvbiBUaW1lADEwLzI0LzA4KQ6r+wAAAClJREFUeJxjfPv2LQMSYPn//z8yn4kBFaDzqa0eXZ5U9QMtT6l5tFYPADsXLPcJwrwLAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/gray-grad.png,importbuddy/images/gray-grad.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/icon_16x16.png,importbuddy/images/icon_16x16.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/icon_16x16.png,importbuddy/images/icon_16x16.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/icon_32x32.png,importbuddy/images/icon_32x32.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/icon_32x32.png,importbuddy/images/icon_32x32.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/loading.gif,importbuddy/images/loading.gif
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/loading.gif,importbuddy/images/loading.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/loading_large.gif,importbuddy/images/loading_large.gif
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/loading_large.gif,importbuddy/images/loading_large.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/pb-logo.png,importbuddy/images/pb-logo.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/pb-logo.png,importbuddy/images/pb-logo.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/images/white-grad.png,importbuddy/images/white-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAeCAYAAADkftS9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAACF0RVh0U29mdHdhcmUATWFjcm9tZWRpYSBGaXJld29ya3MgNC4w6iYndQAAABZ0RVh0Q3JlYXRpb24gVGltZQAxMS8xNy8wONpsdXEAAAAlSURBVHicY/z///9/BjTAhC7AwMDAwIJFIXbBoaJ9qLhz+IUSAIMMOibeSzRBAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/_importbuddy/importbuddy/images/white-grad.png,importbuddy/images/white-grad.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/importbuddy.js,importbuddy/js/importbuddy.js
alF1ZXJ5KGRvY3VtZW50KS5yZWFkeShmdW5jdGlvbigpIHsKCWpRdWVyeSh3aW5kb3cpLmxvYWQoZnVuY3Rpb24oKXsKCQlpZiAoIGpRdWVyeSgnI3BiX2ltcG9ydGJ1ZGR5X3dvcmtpbmcnKS5pcygnOnZpc2libGUnKSApIHsKCQkJalF1ZXJ5KCcjcGJfaW1wb3J0YnVkZHlfd29ya2luZycpLnJlcGxhY2VXaXRoKAoJCQkJalF1ZXJ5KCcjcGJfaW1wb3J0YnVkZHlfYmxhbmthbGVydCcpLmh0bWwoKS5yZXBsYWNlKCAnI1RJVExFIycsICdQSFAgVGltZW91dCBvciBGYXRhbCBFcnJvciBPY2N1cnJlZCcgKS5yZXBsYWNlKCAnI01FU1NBR0UjJywgJ1RoZSBwYWdlIGRpZCBub3QgZmluaXNoIGxvYWRpbmcgYXMgZXhwZWN0ZWQuICBUaGUgbW9zdCBjb21tb24gY2F1c2UgZm9yIHRoaXMgaXMgdGhlIFBIUCBwcm9jZXNzIHRha2luZyBtb3JlIHRpbWUgdGhhbiBpdCBoYXMgYmVlbiBhbGxvd2VkIGJ5IHlvdXIgaG9zdCAocGhwLmluaSBzZXR0aW5nIDxpPm1heF9leGVjdXRpb25fdGltZTwvaT4pLiBJZiBhIFBIUCBlcnJvciBpcyBkaXNwbGF5ZWQgYWJvdmUgdGhpcyBjYW4gYWxzbyBjYXVzZSB0aGlzIGVycm9yLicgKQoJCQkpOwoJCX0KCX0pOwp9KTsKCmpRdWVyeShkb2N1bWVudCkucmVhZHkoZnVuY3Rpb24oKSB7CglqUXVlcnkoJy5wbHVnaW5idWRkeV90aXAnKS50b29sdGlwKHsKCQl0cmFjazogdHJ1ZSwKCQlkZWxheTogMCwKCQlzaG93VVJMOiBmYWxzZSwKCQlzaG93Qm9keTogIiAtICIsCgkJZmFkZTogMjUwCgl9KTsKCQoJalF1ZXJ5KCcudG9nZ2xlJykuY2xpY2soZnVuY3Rpb24oZSkgewoJCWpRdWVyeSggJyN0b2dnbGUtJyArIGpRdWVyeSh0aGlzKS5hdHRyKCdpZCcpICkuc2xpZGVUb2dnbGUoKTsKCX0pOwoJCglqUXVlcnkoJy5vcHRpb25fdG9nZ2xlJykuY2hhbmdlKGZ1bmN0aW9uKGUpIHsKCQlpZiAoalF1ZXJ5KHRoaXMpLmF0dHIoJ2NoZWNrZWQnKSkgewoJCQlqUXVlcnkoJy4nICsgalF1ZXJ5KHRoaXMpLmF0dHIoJ2lkJykgKyAnX3RvZ2dsZScgKS5zbGlkZVRvZ2dsZSgpOwoJCX0gZWxzZSB7CgkJCWpRdWVyeSgnLicgKyBqUXVlcnkodGhpcykuYXR0cignaWQnKSArICdfdG9nZ2xlJyApLnNsaWRlVG9nZ2xlKCk7CgkJfQoJfSk7CgkKCQoJalF1ZXJ5KCcjcGx1Z2luYnVkZHktdGFicycpLnRhYnMoKTsKfSk7
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/importbuddy.js,importbuddy/js/importbuddy.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/jquery.js,importbuddy/js/jquery.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/jquery.js,importbuddy/js/jquery.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/jquery.leanModal.min.js,importbuddy/js/jquery.leanModal.min.js
Ly8gbGVhbk1vZGFsIHYxLjEgYnkgUmF5IFN0b25lIC0gaHR0cDovL2ZpbmVseXNsaWNlZC5jb20uYXUKLy8gRHVhbCBsaWNlbnNlZCB1bmRlciB0aGUgTUlUIGFuZCBHUEwKCihmdW5jdGlvbigkKXskLmZuLmV4dGVuZCh7bGVhbk1vZGFsOmZ1bmN0aW9uKG9wdGlvbnMpe3ZhciBkZWZhdWx0cz17dG9wOjEwMCxvdmVybGF5OjAuNSxjbG9zZUJ1dHRvbjpudWxsfTt2YXIgb3ZlcmxheT0kKCI8ZGl2IGlkPSdsZWFuX292ZXJsYXknPjwvZGl2PiIpOyQoImJvZHkiKS5hcHBlbmQob3ZlcmxheSk7b3B0aW9ucz0kLmV4dGVuZChkZWZhdWx0cyxvcHRpb25zKTtyZXR1cm4gdGhpcy5lYWNoKGZ1bmN0aW9uKCl7dmFyIG89b3B0aW9uczskKHRoaXMpLmNsaWNrKGZ1bmN0aW9uKGUpe3ZhciBtb2RhbF9pZD0kKHRoaXMpLmF0dHIoImhyZWYiKTskKCIjbGVhbl9vdmVybGF5IikuY2xpY2soZnVuY3Rpb24oKXtjbG9zZV9tb2RhbChtb2RhbF9pZCl9KTskKG8uY2xvc2VCdXR0b24pLmNsaWNrKGZ1bmN0aW9uKCl7Y2xvc2VfbW9kYWwobW9kYWxfaWQpfSk7dmFyIG1vZGFsX2hlaWdodD0kKG1vZGFsX2lkKS5vdXRlckhlaWdodCgpO3ZhciBtb2RhbF93aWR0aD0kKG1vZGFsX2lkKS5vdXRlcldpZHRoKCk7CiQoIiNsZWFuX292ZXJsYXkiKS5jc3MoeyJkaXNwbGF5IjoiYmxvY2siLG9wYWNpdHk6MH0pOyQoIiNsZWFuX292ZXJsYXkiKS5mYWRlVG8oMjAwLG8ub3ZlcmxheSk7JChtb2RhbF9pZCkuY3NzKHsiZGlzcGxheSI6ImJsb2NrIiwicG9zaXRpb24iOiJmaXhlZCIsIm9wYWNpdHkiOjAsInotaW5kZXgiOjExMDAwLCJsZWZ0Ijo1MCsiJSIsIm1hcmdpbi1sZWZ0IjotKG1vZGFsX3dpZHRoLzIpKyJweCIsInRvcCI6by50b3ArInB4In0pOyQobW9kYWxfaWQpLmZhZGVUbygyMDAsMSk7ZS5wcmV2ZW50RGVmYXVsdCgpfSl9KTtmdW5jdGlvbiBjbG9zZV9tb2RhbChtb2RhbF9pZCl7JCgiI2xlYW5fb3ZlcmxheSIpLmZhZGVPdXQoMjAwKTskKG1vZGFsX2lkKS5jc3MoeyJkaXNwbGF5Ijoibm9uZSJ9KX19fSl9KShqUXVlcnkpOwo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/jquery.leanModal.min.js,importbuddy/js/jquery.leanModal.min.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/jquery.simple-expand.min.js,importbuddy/js/jquery.simple-expand.min.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/jquery.simple-expand.min.js,importbuddy/js/jquery.simple-expand.min.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/tooltip.js,importbuddy/js/tooltip.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/tooltip.js,importbuddy/js/tooltip.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/ui.core.js,importbuddy/js/ui.core.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/ui.core.js,importbuddy/js/ui.core.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/ui.tabs.js,importbuddy/js/ui.tabs.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/ui.tabs.js,importbuddy/js/ui.tabs.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/js/ui.widget.js,importbuddy/js/ui.widget.js
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/js/ui.widget.js,importbuddy/js/ui.widget.js
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_footer.php,importbuddy/views/_footer.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9Cj8+Cgo8L2Rpdj4KPC9kaXY+CgoKCjw/cGhwIGlmICggcGJfYmFja3VwYnVkZHk6OiRvcHRpb25zWydkaXNwbGF5X21vZGUnXSA9PSAnbm9ybWFsJyApIHsgPz4KCTxkaXYgY2xhc3M9ImZvb3RlciI+PGJyPjxicj4KCQk8Y2VudGVyPgoJCQk8P3BocAoJCQllY2hvICc8YSBocmVmPSJodHRwOi8vcGx1Z2luYnVkZHkuY29tIj48aW1nIHNyYz0iaW1wb3J0YnVkZHkvaW1hZ2VzL3BiLWxvZ28ucG5nIj48L2E+PGJyPic7CgkJCWlmICggcGJfYmFja3VwYnVkZHk6OiRvcHRpb25zWydiYl92ZXJzaW9uJ10gIT0gJycpIHsKCQkJCWVjaG8gJzxicj48c3BhbiBjbGFzcz0iZm9vdGVyX3RleHQiPkltcG9ydEJ1ZGR5IHYnIC4gcGJfYmFja3VwYnVkZHk6OiRvcHRpb25zWydiYl92ZXJzaW9uJ10gLiAnIC0gUG93ZXJlZCBieSA8YSBocmVmPSJodHRwOi8vcGx1Z2luYnVkZHkuY29tIj5CYWNrdXBCdWRkeTwvYT48L3NwYW4+JzsKCQkJfQoJCQk/PgoJCTwvY2VudGVyPgoJPC9kaXY+Cjw/cGhwIH0gPz4KCgoKPC9ib2R5Pgo8L2h0bWw+Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_footer.php,importbuddy/views/_footer.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_header.php,importbuddy/views/_header.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_header.php,importbuddy/views/_header.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/html_1.php,importbuddy/views/html_1.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/html_1.php,importbuddy/views/html_1.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/html_2.php,importbuddy/views/html_2.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/html_2.php,importbuddy/views/html_2.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/html_3.php,importbuddy/views/html_3.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/html_3.php,importbuddy/views/html_3.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/html_4.php,importbuddy/views/html_4.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgokcGFnZV90aXRsZSA9ICdEYXRhYmFzZSBJbXBvcnQnOwpyZXF1aXJlX29uY2UoICdfaGVhZGVyLnBocCcgKTsKZWNobyAnPGRpdiBjbGFzcz0id3JhcCI+JzsKCgokZmFpbGVkID0gZmFsc2U7CgoKZWNobyBwYl9iYWNrdXBidWRkeTo6JGNsYXNzZXNbJ2ltcG9ydCddLT5zdGF0dXNfYm94KCAnSW1wb3J0aW5nIGRhdGFiYXNlIGNvbnRlbnQgd2l0aCBJbXBvcnRCdWRkeSB2JyAuIHBiX2JhY2t1cGJ1ZGR5Ojokb3B0aW9uc1snYmJfdmVyc2lvbiddIC4gJy4uLiBQb3dlcmVkIGJ5IEJhY2t1cEJ1ZGR5LicgKTsKZWNobyAnPGRpdiBpZD0icGJfaW1wb3J0YnVkZHlfd29ya2luZyI+PGltZyBzcmM9IicgLiBwYl9iYWNrdXBidWRkeTo6cGx1Z2luX3VybCgpIC4gJy9pbWFnZXMvbG9hZGluZ19sYXJnZS5naWYiIHRpdGxlPSJXb3JraW5nLi4uIFBsZWFzZSB3YWl0IGFzIHRoaXMgbWF5IHRha2UgYSBtb21lbnQuLi4iPjwvZGl2Pic7CgpwYl9iYWNrdXBidWRkeTo6Zmx1c2goKTsKCgokaW1wb3J0X3Jlc3VsdCA9IGltcG9ydF9kYXRhYmFzZSgpOwoKZWNobyAnPHNjcmlwdCB0eXBlPSJ0ZXh0L2phdmFzY3JpcHQiPmpRdWVyeSgiI3BiX2ltcG9ydGJ1ZGR5X3dvcmtpbmciKS5oaWRlKCk7PC9zY3JpcHQ+JzsKCmlmICggJGltcG9ydF9yZXN1bHRbMF0gPT0gdHJ1ZSApIHsKCWlmICggJGltcG9ydF9yZXN1bHRbMV0gIT09IHRydWUgKSB7IC8vIGlmIG5vdCBmaW5pc2hlZC4KCQlwYl9iYWNrdXBidWRkeTo6YWxlcnQoICdEYXRhYmFzZSB0b28gbGFyZ2UgdG8gaW1wb3J0IGluIG9uZSBzdGVwIHNvIGl0IHdpbGwgYmUgaW1wb3J0ZWQgaW4gY2h1bmtzLiBQbGVhc2UgY29udGludWUgdGhlIHByb2Nlc3MgdW50aWwgdGhpcyBzdGVwIGlzIGZpbmlzaGVkLiBUaGlzIG1heSB0YWtlIGEgZmV3IHN0ZXBzIGRlcGVuZGluZyBvbiB0aGUgc2l6ZSBvZiB5b3VyIGRhdGFiYXNlIGFuZCBzZXJ2ZXIgc3BlZWQuJyApOwoJCWVjaG8gJzxicj4nOwoJCWVjaG8gJ1BsZWFzZSBrZWVwIGNvbnRpbnVpbmcgdW50aWwgeW91ciBkYXRhYmFzZSBoYXMgZnVsbHkgaW1wb3J0ZWQuIFRoaXMgbWF5IHRha2UgYSBmZXcgc3RlcHMuJzsKCQllY2hvICc8Zm9ybSBhY3Rpb249Ij9zdGVwPTQiIG1ldGhvZD1wb3N0Pic7CgkJZWNobyAnPGlucHV0IHR5cGU9ImhpZGRlbiIgbmFtZT0icGFzc19oYXNoIiBpZD0icGFzc19oYXNoIiB2YWx1ZT0iJyAuIGh0bWxzcGVjaWFsY2hhcnMoIHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ3Bhc3NfaGFzaCcgKSApIC4gJyI+JzsKCQllY2hvICc8aW5wdXQgdHlwZT0iaGlkZGVuIiBuYW1lPSJkYl9jb250aW51ZSIgdmFsdWU9IicgLiAkaW1wb3J0X3Jlc3VsdFsxXSAuICciPic7CgkJZWNobyAnPGlucHV0IHR5cGU9ImhpZGRlbiIgbmFtZT0ib3B0aW9ucyIgdmFsdWU9IicgLiBodG1sc3BlY2lhbGNoYXJzKCBzZXJpYWxpemUoIHBiX2JhY2t1cGJ1ZGR5Ojokb3B0aW9ucyApICkgLiAnIiAvPic7CgkJZWNobyAnPC9kaXY+PCEtLSAvd3JhcCAtLT4nOwoJCWVjaG8gJzxkaXYgY2xhc3M9Im1haW5fYm94X2Zvb3QiPjxpbnB1dCB0eXBlPSJzdWJtaXQiIG5hbWU9InN1Ym1pdCIgY2xhc3M9ImJ1dHRvbiIgdmFsdWU9IkNvbnRpbnVlIERhdGFiYXNlIEltcG9ydCAmcmFycjsiIC8+PC9kaXY+JzsKCQllY2hvICc8L2Zvcm0+JzsKCX0gZWxzZSB7CgkJZWNobyAnPHAgc3R5bGU9InRleHQtYWxpZ246IGNlbnRlcjsiPkluaXRpYWwgZGF0YWJhc2UgaW1wb3J0IGNvbXBsZXRlITwvcD48YnI+JzsKCQllY2hvICdOZXh0IHRoZSBkYXRhIGluIHRoZSBkYXRhYmFzZSB3aWxsIGJlIG1pZ3JhdGVkIHRvIGFjY291bnQgZm9yIGFueSBmaWxlIHBhdGggb3IgVVJMIGNoYW5nZXMuJzsKCQllY2hvICc8Zm9ybSBhY3Rpb249Ij9zdGVwPTUiIG1ldGhvZD1wb3N0Pic7CgkJZWNobyAnPGlucHV0IHR5cGU9ImhpZGRlbiIgbmFtZT0icGFzc19oYXNoIiBpZD0icGFzc19oYXNoIiB2YWx1ZT0iJyAuIGh0bWxzcGVjaWFsY2hhcnMoIHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ3Bhc3NfaGFzaCcgKSApIC4gJyI+JzsKCQllY2hvICc8aW5wdXQgdHlwZT0iaGlkZGVuIiBuYW1lPSJvcHRpb25zIiB2YWx1ZT0iJyAuIGh0bWxzcGVjaWFsY2hhcnMoIHNlcmlhbGl6ZSggcGJfYmFja3VwYnVkZHk6OiRvcHRpb25zICkgKSAuICciIC8+JzsKCQllY2hvICc8L2Rpdj48IS0tIC93cmFwIC0tPic7CgkJZWNobyAnPGRpdiBjbGFzcz0ibWFpbl9ib3hfZm9vdCI+PGlucHV0IHR5cGU9InN1Ym1pdCIgbmFtZT0ic3VibWl0IiBjbGFzcz0iYnV0dG9uIiB2YWx1ZT0iTmV4dCBTdGVwICZyYXJyOyIgLz48L2Rpdj4nOwoJCWVjaG8gJzwvZm9ybT4nOwoJfQp9IGVsc2UgewoJZWNobyAnPGJyPjxwIHN0eWxlPSJ0ZXh0LWFsaWduOiBjZW50ZXI7Ij5EYXRhYmFzZSBpbXBvcnQgZmFpbGVkLiBQbGVhc2UgdXNlIHlvdXIgYmFjayBidXR0b24gdG8gY29ycmVjdCBhbnkgZXJyb3JzLjwvcD4nOwoJZWNobyAnPC9kaXY+PCEtLSAvd3JhcCAtLT4nOwp9CgoKCnJlcXVpcmVfb25jZSggJ19mb290ZXIucGhwJyApOwo/Pgo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/html_4.php,importbuddy/views/html_4.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/html_5.php,importbuddy/views/html_5.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/html_5.php,importbuddy/views/html_5.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/html_6.php,importbuddy/views/html_6.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgokcGFnZV90aXRsZSA9ICdGaW5hbCBDbGVhbnVwJzsKcmVxdWlyZV9vbmNlKCAnX2hlYWRlci5waHAnICk7CmVjaG8gJzxkaXYgY2xhc3M9IndyYXAiPic7CgplY2hvIHBiX2JhY2t1cGJ1ZGR5OjokY2xhc3Nlc1snaW1wb3J0J10tPnN0YXR1c19ib3goICdDbGVhbmluZyB1cCBhZnRlciByZXN0b3JlIHdpdGggSW1wb3J0QnVkZHkgdicgLiBwYl9iYWNrdXBidWRkeTo6JG9wdGlvbnNbJ2JiX3ZlcnNpb24nXSAuICcuLi4gUG93ZXJlZCBieSBCYWNrdXBCdWRkeS4nICk7CmVjaG8gJzxkaXYgaWQ9InBiX2ltcG9ydGJ1ZGR5X3dvcmtpbmciPjxpbWcgc3JjPSInIC4gcGJfYmFja3VwYnVkZHk6OnBsdWdpbl91cmwoKSAuICcvaW1hZ2VzL2xvYWRpbmdfbGFyZ2UuZ2lmIiB0aXRsZT0iV29ya2luZy4uLiBQbGVhc2Ugd2FpdCBhcyB0aGlzIG1heSB0YWtlIGEgbW9tZW50Li4uIj48L2Rpdj4nOwoKCi8vIEF0dGVtcHQgdG8gZmx1c2ggdGhlIHBhZ2UgYW5kIHBhdXNlIHNvIGFzc2V0cyAoQ1NTLCBpbWFnZXMpIGNhbiBsb2FkIGJlZm9yZSBhY3R1YWwgZmlsZXMgZ2V0IGRlbGV0ZWQgYnkgY2xlYW51cCgpLgpwYl9iYWNrdXBidWRkeTo6Zmx1c2goKTsKc2xlZXAoIDQgKTsgLy8gUGF1c2Ugc2VydmVyLXNpZGUgYnJpZWZseSB0byBnaXZlIHRpbWUgZm9yIHRoZWlyIGJyb3dzZXIgdG8gbG9hZCBhc3NldHMuCnBiX2JhY2t1cGJ1ZGR5OjpmbHVzaCgpOwoKCi8vIENsZWFudXAhCmNsZWFudXAoKTsKCgplY2hvICc8c2NyaXB0IHR5cGU9InRleHQvamF2YXNjcmlwdCI+alF1ZXJ5KCIjcGJfaW1wb3J0YnVkZHlfd29ya2luZyIpLmhpZGUoKTs8L3NjcmlwdD4nOwoKZWNobyAnVGhpcyBzdGVwIGhhbmRsZXMgY2xlYW51cCBvZiBmaWxlcy4gSXQgaXMgY29tbW9uIHRvIG5vdCBiZSBhYmxlIHRvIGRlbGV0ZSBzb21lIGZpbGVzIGR1ZSB0byBwZXJtaXNzaW9uIGVycm9ycy4gWW91IG1heSBtYW51YWxseSBkZWxldGUgdGhlbS4gPGI+aW1wb3J0YnVkZHkucGhwPC9iPiBzaG91bGQgYWx3YXlzIGJlIGRlbGV0ZWQgYWZ0ZXIgcmVzdG9yZSBmb3IgYmVzdCBzZWN1cml0eS48YnI+PGJyPic7CgplY2hvICc8aDMgc3R5bGU9InRleHQtYWxpZ246IGNlbnRlcjsiPllvdXIgc2l0ZSBpcyByZWFkeSB0byBnbyBhdDxicj48YnI+JzsKZWNobyAnPGEgaHJlZj0iJyAuIHBiX2JhY2t1cGJ1ZGR5Ojokb3B0aW9uc1snaG9tZSddIC4gJyIgdGFyZ2V0PSJfbmV3Ij48Yj4nIC4gcGJfYmFja3VwYnVkZHk6OiRvcHRpb25zWydob21lJ10gLiAnPC9iPjwvYT48YnI+PGJyPic7CmVjaG8gJ1RoYW5rIHlvdSBmb3IgY2hvb3NpbmcgQmFja3VwQnVkZHkhPC9oMz4nOwoKCmVjaG8gJzwvZGl2PjwvZGl2Pjxicj48YnI+PGJyPic7Cj8+Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/html_6.php,importbuddy/views/html_6.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/cpanel_createdb.php,importbuddy/controllers/ajax/cpanel_createdb.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgpBdXRoOjpyZXF1aXJlX2F1dGhlbnRpY2F0aW9uKCk7IC8vIERpZSBpZiBub3QgbG9nZ2VkIGluLgoKLy9wcmludF9yKCBwYl9iYWNrdXBidWRkeTo6X1BPU1QoKSApOwoKJGNwYW5lbF91c2VyID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3VzZXInICk7CiRjcGFuZWxfcGFzc3dvcmQgPSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdjcGFuZWxfcGFzcycgKTsKJGNwYW5lbF9ob3N0ID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3VybCcgKTsKJGNwYW5lbF9wb3J0ID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3BvcnQnICk7CiRkYl9uYW1lID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX2RibmFtZScgKTsKJGRiX3VzZXIgPSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdjcGFuZWxfZGJ1c2VyJyApOwokZGJfcGFzcyA9IHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ2NwYW5lbF9kYnBhc3MnICk7CgovLyBOZWVkZWQgZm9yIEhUVFAgcmVxdWVzdHMuCiRyZXF1ZXN0Y29yZV9maWxlID0gcGJfYmFja3VwYnVkZHk6OnBsdWdpbl9wYXRoKCkgLiAnL2xpYi9yZXF1ZXN0Y29yZS9yZXF1ZXN0Y29yZS5jbGFzcy5waHAnOwpyZXF1aXJlX29uY2UoICRyZXF1ZXN0Y29yZV9maWxlICk7CgpyZXF1aXJlX29uY2UoIHBiX2JhY2t1cGJ1ZGR5OjpwbHVnaW5fcGF0aCgpIC4gJy9saWIvY3BhbmVsL2NwYW5lbC5waHAnICk7CiRjcmVhdGVfZGJfcmVzdWx0ID0gcGJfYmFja3VwYnVkZHlfY3BhbmVsOjpjcmVhdGVfZGIoICRjcGFuZWxfdXNlciwgJGNwYW5lbF9wYXNzd29yZCwgJGNwYW5lbF9ob3N0LCAkZGJfbmFtZSwgJGRiX3VzZXIsICRkYl9wYXNzLCAkY3BhbmVsX3BvcnQgKTsKCmlmICggJGNyZWF0ZV9kYl9yZXN1bHQgPT09IHRydWUgKSB7CgllY2hvICdTdWNjZXNzISBDcmVhdGVkIGRhdGFiYXNlLCB1c2VyLCBhbmQgYXNzaWduZWQgdXNlciB0byBkYXRhYmFzZS4nOwp9IGVsc2UgewoJZWNobyAiVW5hYmxlIHRvIGF1dG9tYXRpY2FsbHkgY3JlYXRlIGRhdGFiYXNlIHdpdGggdGhlIHByb3ZpZGVkIHNldHRpbmdzLiBDaGVjayBzZXR0aW5ncyBvciBtYW51YWxseSBjcmVhdGUgdGhlIGRhdGFiYXNlIGZyb20geW91ciBob3N0J3MgY29udHJvbCBwYW5lbC4gU2VlIHR1dG9yaWFsIGF0OiAiOwoJZWNobyAiaHR0cDovL3BsdWdpbmJ1ZGR5LmNvbS90dXRvcmlhbC1jcmVhdGUtZGF0YWJhc2UtaW4tY3BhbmVsL1xuXG4iOwoJZWNobyAiRXJyb3IgZGV0YWlsczpcbiIgLiBpbXBsb2RlKCAiXG4iLCAkY3JlYXRlX2RiX3Jlc3VsdCk7Cn0KCmRpZSgpOwo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/cpanel_createdb.php,importbuddy/controllers/ajax/cpanel_createdb.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/create_admin.php,importbuddy/controllers/ajax/create_admin.php
PD9waHAKZGllKCAnPGh0bWw+PC9odG1sPicgKTsgLy8gRElTQUJMRUQuCgpBdXRoOjpyZXF1aXJlX2F1dGhlbnRpY2F0aW9uKCk7IC8vIERpZSBpZiBub3QgbG9nZ2VkIGluLgoKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgppZiAoIGZpbGVfZXhpc3RzKCBBQlNQQVRIIC4gJ3dwLWxvYWQucGhwJyApICkgewoJb2Jfc3RhcnQoICdvYl9lcnJvcl9oYW5kbGVyJyApOyAvL1N1cHByZXNzIGVycm9ycwoJcmVxdWlyZV9vbmNlKCBBQlNQQVRIIC4gJ3dwLWxvYWQucGhwJyApOwoJb2JfZW5kX2NsZWFuKCk7Cn0gZWxzZSB7CglkaWUoICdVbmFibGUgdG8gZmluZCBXb3JkUHJlc3MgZmlsZXMgdG8gbG9hZCAod3AtbG9hZC5waHApLiBWZXJpZnkgeW91ciBXb3JkUHJlc3Mgc2l0ZSBpcyBmdW5jdGlvbmFsIGFuZCBhYmxlIHRvIGNvbm5lY3QgdG8gdGhlIGRhdGFiYXNlLicgKTsKfQoKJHVzZXIgPSBnZXRfdXNlcl9ieSggJ2xvZ2luJywgJHNlYXJjaF9zdHJpbmcgKTsKaWYgKCAkdXNlciApIGRpZSgganNvbl9lbmNvZGUoICR1c2VyICkgKTsK
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/create_admin.php,importbuddy/controllers/ajax/create_admin.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/mysql_test.php,importbuddy/controllers/ajax/mysql_test.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/mysql_test.php,importbuddy/controllers/ajax/mysql_test.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/1.php,importbuddy/controllers/pages/1.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/1.php,importbuddy/controllers/pages/1.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/2.php,importbuddy/controllers/pages/2.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/2.php,importbuddy/controllers/pages/2.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/3.php,importbuddy/controllers/pages/3.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/3.php,importbuddy/controllers/pages/3.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/4.php,importbuddy/controllers/pages/4.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/4.php,importbuddy/controllers/pages/4.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/5.php,importbuddy/controllers/pages/5.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/5.php,importbuddy/controllers/pages/5.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/6.php,importbuddy/controllers/pages/6.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/6.php,importbuddy/controllers/pages/6.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/create_admin.php,importbuddy/controllers/pages/create_admin.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/create_admin.php,importbuddy/controllers/pages/create_admin.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/default.php,importbuddy/controllers/pages/default.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/default.php,importbuddy/controllers/pages/default.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/lib/pclzip/pclzip.php,importbuddy/lib/pclzip/pclzip.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/lib/pclzip/pclzip.php,importbuddy/lib/pclzip/pclzip.php
###PACKDATA,FILE_START,/classes/_migrate_database.php,importbuddy/classes/_migrate_database.php
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
###PACKDATA,FILE_END,/classes/_migrate_database.php,importbuddy/classes/_migrate_database.php
###PACKDATA,FILE_START,/classes/core.php,importbuddy/classes/core.php
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
###PACKDATA,FILE_END,/classes/core.php,importbuddy/classes/core.php
###PACKDATA,FILE_START,/classes/import.php,importbuddy/classes/import.php
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
###PACKDATA,FILE_END,/classes/import.php,importbuddy/classes/import.php
###PACKDATA,FILE_START,/images/working.gif,importbuddy/images/working.gif
R0lGODlhKwALAPEAAPn5+SiKt5LC2CiKtyH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQJCgAAACwAAAAAKwALAAACMoSOCMuW2diD88UKG95W88uF4DaGWFmhZid93pq+pwxnLUnXh8ou+sSz+T64oCAyTBUAACH5BAkKAAAALAAAAAArAAsAAAI9xI4IyyAPYWOxmoTHrHzzmGHe94xkmJifyqFKQ0pwLLgHa82xrekkDrIBZRQab1jyfY7KTtPimixiUsevAAAh+QQJCgAAACwAAAAAKwALAAACPYSOCMswD2FjqZpqW9xv4g8KE7d54XmMpNSgqLoOpgvC60xjNonnyc7p+VKamKw1zDCMR8rp8pksYlKorgAAIfkECQoAAAAsAAAAACsACwAAAkCEjgjLltnYmJS6Bxt+sfq5ZUyoNJ9HHlEqdCfFrqn7DrE2m7Wdj/2y45FkQ13t5itKdshFExC8YCLOEBX6AhQAADs=
###PACKDATA,FILE_END,/images/working.gif,importbuddy/images/working.gif
###PACKDATA,FILE_START,/images/bullet_go.png,importbuddy/images/bullet_go.png
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAEsSURBVDjLY/j//z8DJZhhmBuQvdj8a+p8w//xc3U5yTIgeb7h18bNUf/DZ2j8958qz0nQgPyltv9zF5v/TV9o/Ddxrv7fmvWh/1ednvi/ZLX/f9d+8b+23YI8eA0AOvn/hnPT/q89OwWsccXpCf8n7Cn5v/B41/+MpW7/TdvZ/+o2M/LjNADoZLDmvl35/zt3ZP9v3Zb2v2Fz4v+mren/Zxxq/h+zwOa/aj3DH5wGRM/W/L/y1IT/S0/0/l94rOv/vKMdQEOy/k8/1PQ/banHf8VahlfSlQwGOA0InK74z3Oi9D/nftF/1t38/+LmW/2fdrDhf9Jit//ytQzPJSsZtEiKBe1mxq/xC53/y1czPAFqVic5GoFO/ipXzfxftJJBkeyUKFzOwDm48wIAh5XH+g7drOwAAAAASUVORK5CYII=
###PACKDATA,FILE_END,/images/bullet_go.png,importbuddy/images/bullet_go.png
###PACKDATA,FILE_START,/images/favicon.png,importbuddy/images/favicon.png
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
###PACKDATA,FILE_END,/images/favicon.png,importbuddy/images/favicon.png
###PACKDATA,FILE_START,/images/sort_down.png,importbuddy/images/sort_down.png
iVBORw0KGgoAAAANSUhEUgAAAAoAAAAICAYAAADA+m62AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAHBJREFUeNqMkD0OABEQRmcmVChIqN3/WBJHoLVYxK7GK4TvZwIMIcANrC0xxpJSOkzOOXjvASvUBOdcOxzBoXeDRhO11p+QlBKEEKtNc2OMAcbYKxL1aTsrWE201u4lPB4zUUphzrn8r9HA2+95BBgA3YASwqCieowAAAAASUVORK5CYII=
###PACKDATA,FILE_END,/images/sort_down.png,importbuddy/images/sort_down.png
###PACKDATA,FILE_START,/lib/dbreplace/dbreplace.php,importbuddy/lib/dbreplace/dbreplace.php
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
###PACKDATA,FILE_END,/lib/dbreplace/dbreplace.php,importbuddy/lib/dbreplace/dbreplace.php
###PACKDATA,FILE_START,/lib/dbreplace/history.txt,importbuddy/lib/dbreplace/history.txt
MS4wLjAgLSAyMDExLTA4LTE4IC0gRHVzdGluIEJvbHRvbgoJQ3JlYXRlZCBkYnJlcGxhY2UgY2xhc3Mu
###PACKDATA,FILE_END,/lib/dbreplace/history.txt,importbuddy/lib/dbreplace/history.txt
###PACKDATA,FILE_START,/lib/dbreplace/index.php,importbuddy/lib/dbreplace/index.php
PD9waHAKLy8gU2lsZW5jZSBpcyBnb2xkZW4uCj8+
###PACKDATA,FILE_END,/lib/dbreplace/index.php,importbuddy/lib/dbreplace/index.php
###PACKDATA,FILE_START,/lib/commandbuddy/commandbuddy.php,importbuddy/lib/commandbuddy/commandbuddy.php
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
###PACKDATA,FILE_END,/lib/commandbuddy/commandbuddy.php,importbuddy/lib/commandbuddy/commandbuddy.php
###PACKDATA,FILE_START,/lib/commandbuddy/index.php,importbuddy/lib/commandbuddy/index.php
PD9waHAKLy8gU2lsZW5jZSBpcyBnb2xkZW4uCj8+
###PACKDATA,FILE_END,/lib/commandbuddy/index.php,importbuddy/lib/commandbuddy/index.php
###PACKDATA,FILE_START,/lib/zipbuddy/history.txt,importbuddy/lib/zipbuddy/history.txt
Mi4wLjAgLSAyMDExLTEwLTA4IC0gRHVzdGluIEJvbHRvbgoJQWRkZWQgaGlzdG9yeS50eHQuCglBZGRlZCB1bnppcCBmdW5jdGlvbmFsaXR5Lg==
###PACKDATA,FILE_END,/lib/zipbuddy/history.txt,importbuddy/lib/zipbuddy/history.txt
###PACKDATA,FILE_START,/lib/zipbuddy/index.php,importbuddy/lib/zipbuddy/index.php
PD9waHAKLy8gU2lsZW5jZSBpcyBnb2xkZW4uCj8+
###PACKDATA,FILE_END,/lib/zipbuddy/index.php,importbuddy/lib/zipbuddy/index.php
###PACKDATA,FILE_START,/lib/zipbuddy/legacy.zipbuddy.php,importbuddy/lib/zipbuddy/legacy.zipbuddy.php
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