/**
 * jscolor, JavaScript Color Picker
 *
 * @version 1.4.0
 * @license GNU Lesser General Public License, http://www.gnu.org/copyleft/lesser.html
 * @author  Jan Odvarko, http://odvarko.cz
 * @created 2008-06-15
 * @updated 2012-07-06
 * @link    http://jscolor.com
 */
var jscolor={dir:"",bindClass:"color",binding:true,preloading:true,install:function(){jscolor.addEvent(window,"load",jscolor.init)},init:function(){if(jscolor.binding){jscolor.bind()}if(jscolor.preloading){jscolor.preload()}},getDir:function(){if(!jscolor.dir){var a=jscolor.detectDir();jscolor.dir=a!==false?a:"jscolor/"}return jscolor.dir},detectDir:function(){var c=location.href;var d=document.getElementsByTagName("base");for(var a=0;a<d.length;a+=1){if(d[a].href){c=d[a].href}}var d=document.getElementsByTagName("script");for(var a=0;a<d.length;a+=1){if(d[a].src&&/(^|\/)jscolor\.js([?#].*)?$/i.test(d[a].src)){var f=new jscolor.URI(d[a].src);var b=f.toAbsolute(c);b.path=b.path.replace(/[^\/]+$/,"");b.query=null;b.fragment=null;return b.toString()}}return false},bind:function(){var d=new RegExp("(^|\\s)("+jscolor.bindClass+")\\s*(\\{[^}]*\\})?","i");var f=document.getElementsByTagName("input");for(var c=0;c<f.length;c+=1){var b;if(!f[c].color&&f[c].className&&(b=f[c].className.match(d))){var g={};if(b[3]){try{g=(new Function("return ("+b[3]+")"))()}catch(a){}}f[c].color=new jscolor.color(f[c],g)}}},preload:function(){for(var a in jscolor.imgRequire){if(jscolor.imgRequire.hasOwnProperty(a)){jscolor.loadImage(a)}}},images:{pad:[181,101],sld:[16,101],cross:[15,15],arrow:[7,11]},imgRequire:{},imgLoaded:{},requireImage:function(a){jscolor.imgRequire[a]=true},loadImage:function(a){if(!jscolor.imgLoaded[a]){jscolor.imgLoaded[a]=new Image();jscolor.imgLoaded[a].src=jscolor.getDir()+a}},fetchElement:function(a){return typeof a==="string"?document.getElementById(a):a},addEvent:function(a,c,b){if(a.addEventListener){a.addEventListener(c,b,false)}else{if(a.attachEvent){a.attachEvent("on"+c,b)}}},fireEvent:function(a,c){if(!a){return}if(document.createEvent){var b=document.createEvent("HTMLEvents");b.initEvent(c,true,true);a.dispatchEvent(b)}else{if(document.createEventObject){var b=document.createEventObject();a.fireEvent("on"+c,b)}else{if(a["on"+c]){a["on"+c]()}}}},getElementPos:function(c){var d=c,b=c;var a=0,f=0;if(d.offsetParent){do{a+=d.offsetLeft;f+=d.offsetTop}while(d=d.offsetParent)}while((b=b.parentNode)&&b.nodeName.toUpperCase()!=="BODY"){a-=b.scrollLeft;f-=b.scrollTop}return[a,f]},getElementSize:function(a){return[a.offsetWidth,a.offsetHeight]},getRelMousePos:function(b){var a=0,c=0;if(!b){b=window.event}if(typeof b.offsetX==="number"){a=b.offsetX;c=b.offsetY}else{if(typeof b.layerX==="number"){a=b.layerX;c=b.layerY}}return{x:a,y:c}},getViewPos:function(){if(typeof window.pageYOffset==="number"){return[window.pageXOffset,window.pageYOffset]}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){return[document.body.scrollLeft,document.body.scrollTop]}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){return[document.documentElement.scrollLeft,document.documentElement.scrollTop]}else{return[0,0]}}}},getViewSize:function(){if(typeof window.innerWidth==="number"){return[window.innerWidth,window.innerHeight]}else{if(document.body&&(document.body.clientWidth||document.body.clientHeight)){return[document.body.clientWidth,document.body.clientHeight]}else{if(document.documentElement&&(document.documentElement.clientWidth||document.documentElement.clientHeight)){return[document.documentElement.clientWidth,document.documentElement.clientHeight]}else{return[0,0]}}}},URI:function(a){this.scheme=null;this.authority=null;this.path="";this.query=null;this.fragment=null;this.parse=function(d){var c=d.match(/^(([A-Za-z][0-9A-Za-z+.-]*)(:))?((\/\/)([^\/?#]*))?([^?#]*)((\?)([^#]*))?((#)(.*))?/);this.scheme=c[3]?c[2]:null;this.authority=c[5]?c[6]:null;this.path=c[7];this.query=c[9]?c[10]:null;this.fragment=c[12]?c[13]:null;return this};this.toString=function(){var c="";if(this.scheme!==null){c=c+this.scheme+":"}if(this.authority!==null){c=c+"//"+this.authority}if(this.path!==null){c=c+this.path}if(this.query!==null){c=c+"?"+this.query}if(this.fragment!==null){c=c+"#"+this.fragment}return c};this.toAbsolute=function(e){var e=new jscolor.URI(e);var d=this;var c=new jscolor.URI;if(e.scheme===null){return false}if(d.scheme!==null&&d.scheme.toLowerCase()===e.scheme.toLowerCase()){d.scheme=null}if(d.scheme!==null){c.scheme=d.scheme;c.authority=d.authority;c.path=b(d.path);c.query=d.query}else{if(d.authority!==null){c.authority=d.authority;c.path=b(d.path);c.query=d.query}else{if(d.path===""){c.path=e.path;if(d.query!==null){c.query=d.query}else{c.query=e.query}}else{if(d.path.substr(0,1)==="/"){c.path=b(d.path)}else{if(e.authority!==null&&e.path===""){c.path="/"+d.path}else{c.path=e.path.replace(/[^\/]+$/,"")+d.path}c.path=b(c.path)}c.query=d.query}c.authority=e.authority}c.scheme=e.scheme}c.fragment=d.fragment;return c};function b(e){var c="";while(e){if(e.substr(0,3)==="../"||e.substr(0,2)==="./"){e=e.replace(/^\.+/,"").substr(1)}else{if(e.substr(0,3)==="/./"||e==="/."){e="/"+e.substr(3)}else{if(e.substr(0,4)==="/../"||e==="/.."){e="/"+e.substr(4);c=c.replace(/\/?[^\/]*$/,"")}else{if(e==="."||e===".."){e=""}else{var d=e.match(/^\/?[^\/]*/)[0];e=e.substr(d.length);c=c+d}}}}}return c}if(a){this.parse(a)}},color:function(A,d){this.required=true;this.adjust=true;this.hash=false;this.caps=true;this.slider=true;this.valueElement=A;this.styleElement=A;this.onImmediateChange=null;this.hsv=[0,0,1];this.rgb=[1,1,1];this.minH=0;this.maxH=6;this.minS=0;this.maxS=1;this.minV=0;this.maxV=1;this.pickerOnfocus=true;this.pickerMode="HSV";this.pickerPosition="bottom";this.pickerSmartPosition=true;this.pickerButtonHeight=20;this.pickerClosable=false;this.pickerCloseText="Close";this.pickerButtonColor="ButtonText";this.pickerFace=10;this.pickerFaceColor="ThreeDFace";this.pickerBorder=1;this.pickerBorderColor="ThreeDHighlight ThreeDShadow ThreeDShadow ThreeDHighlight";this.pickerInset=1;this.pickerInsetColor="ThreeDShadow ThreeDHighlight ThreeDHighlight ThreeDShadow";this.pickerZIndex=10000;for(var r in d){if(d.hasOwnProperty(r)){this[r]=d[r]}}this.hidePicker=function(){if(t()){g()}};this.showPicker=function(){if(!t()){var J=jscolor.getElementPos(A);var G=jscolor.getElementSize(A);var D=jscolor.getViewPos();var L=jscolor.getViewSize();var p=s(this);var K,I,H;switch(this.pickerPosition.toLowerCase()){case"left":K=1;I=0;H=-1;break;case"right":K=1;I=0;H=1;break;case"top":K=0;I=1;H=-1;break;default:K=0;I=1;H=1;break}var F=(G[I]+p[I])/2;if(!this.pickerSmartPosition){var E=[J[K],J[I]+G[I]-F+F*H]}else{var E=[-D[K]+J[K]+p[K]>L[K]?(-D[K]+J[K]+G[K]/2>L[K]/2&&J[K]+G[K]-p[K]>=0?J[K]+G[K]-p[K]:J[K]):J[K],-D[I]+J[I]+G[I]+p[I]-F+F*H>L[I]?(-D[I]+J[I]+G[I]/2>L[I]/2&&J[I]+G[I]-F-F*H>=0?J[I]+G[I]-F-F*H:J[I]+G[I]-F+F*H):(J[I]+G[I]-F+F*H>=0?J[I]+G[I]-F+F*H:J[I]+G[I]-F-F*H)]}j(E[K],E[I])}};this.importColor=function(){if(!a){this.exportColor()}else{if(!this.adjust){if(!this.fromString(a.value,w)){C.style.backgroundImage=C.jscStyle.backgroundImage;C.style.backgroundColor=C.jscStyle.backgroundColor;C.style.color=C.jscStyle.color;this.exportColor(w|B)}}else{if(!this.required&&/^\s*$/.test(a.value)){a.value="";C.style.backgroundImage=C.jscStyle.backgroundImage;C.style.backgroundColor=C.jscStyle.backgroundColor;C.style.color=C.jscStyle.color;this.exportColor(w|B)}else{if(this.fromString(a.value)){}else{this.exportColor()}}}}};this.exportColor=function(p){if(!(p&w)&&a){var D=this.toString();if(this.caps){D=D.toUpperCase()}if(this.hash){D="#"+D}a.value=D}if(!(p&B)&&C){C.style.backgroundImage="none";C.style.backgroundColor="#"+this.toString();C.style.color=0.213*this.rgb[0]+0.715*this.rgb[1]+0.072*this.rgb[2]<0.5?"#FFF":"#000"}if(!(p&u)&&t()){q()}if(!(p&e)&&t()){z()}};this.fromHSV=function(F,E,D,p){if(F!==null){F=Math.max(0,this.minH,Math.min(6,this.maxH,F))}if(E!==null){E=Math.max(0,this.minS,Math.min(1,this.maxS,E))}if(D!==null){D=Math.max(0,this.minV,Math.min(1,this.maxV,D))}this.rgb=h(F===null?this.hsv[0]:(this.hsv[0]=F),E===null?this.hsv[1]:(this.hsv[1]=E),D===null?this.hsv[2]:(this.hsv[2]=D));this.exportColor(p)};this.fromRGB=function(H,G,p,D){if(H!==null){H=Math.max(0,Math.min(1,H))}if(G!==null){G=Math.max(0,Math.min(1,G))}if(p!==null){p=Math.max(0,Math.min(1,p))}var F=x(H===null?this.rgb[0]:H,G===null?this.rgb[1]:G,p===null?this.rgb[2]:p);if(F[0]!==null){this.hsv[0]=Math.max(0,this.minH,Math.min(6,this.maxH,F[0]))}if(F[2]!==0){this.hsv[1]=F[1]===null?null:Math.max(0,this.minS,Math.min(1,this.maxS,F[1]))}this.hsv[2]=F[2]===null?null:Math.max(0,this.minV,Math.min(1,this.maxV,F[2]));var E=h(this.hsv[0],this.hsv[1],this.hsv[2]);this.rgb[0]=E[0];this.rgb[1]=E[1];this.rgb[2]=E[2];this.exportColor(D)};this.fromString=function(E,D){var p=E.match(/^\W*([0-9A-F]{3}([0-9A-F]{3})?)\W*$/i);if(!p){return false}else{if(p[1].length===6){this.fromRGB(parseInt(p[1].substr(0,2),16)/255,parseInt(p[1].substr(2,2),16)/255,parseInt(p[1].substr(4,2),16)/255,D)}else{this.fromRGB(parseInt(p[1].charAt(0)+p[1].charAt(0),16)/255,parseInt(p[1].charAt(1)+p[1].charAt(1),16)/255,parseInt(p[1].charAt(2)+p[1].charAt(2),16)/255,D)}return true}};this.toString=function(){return((256|Math.round(255*this.rgb[0])).toString(16).substr(1)+(256|Math.round(255*this.rgb[1])).toString(16).substr(1)+(256|Math.round(255*this.rgb[2])).toString(16).substr(1))};function x(H,G,D){var I=Math.min(Math.min(H,G),D);var E=Math.max(Math.max(H,G),D);var p=E-I;if(p===0){return[null,0,E]}var F=H===I?3+(D-G)/p:(G===I?5+(H-D)/p:1+(G-H)/p);return[F===6?0:F,p/E,E]}function h(G,F,D){if(G===null){return[D,D,D]}var E=Math.floor(G);var H=E%2?G-E:1-(G-E);var p=D*(1-F);var I=D*(1-F*H);switch(E){case 6:case 0:return[D,I,p];case 1:return[I,D,p];case 2:return[p,D,I];case 3:return[p,I,D];case 4:return[I,p,D];case 5:return[D,p,I]}}function g(){delete jscolor.picker.owner;document.getElementsByTagName("body")[0].removeChild(jscolor.picker.boxB)}function j(K,J){if(!jscolor.picker){jscolor.picker={box:document.createElement("div"),boxB:document.createElement("div"),pad:document.createElement("div"),padB:document.createElement("div"),padM:document.createElement("div"),sld:document.createElement("div"),sldB:document.createElement("div"),sldM:document.createElement("div"),btn:document.createElement("div"),btnS:document.createElement("span"),btnT:document.createTextNode(k.pickerCloseText)};for(var H=0,I=4;H<jscolor.images.sld[1];H+=I){var G=document.createElement("div");G.style.height=I+"px";G.style.fontSize="1px";G.style.lineHeight="0";jscolor.picker.sld.appendChild(G)}jscolor.picker.sldB.appendChild(jscolor.picker.sld);jscolor.picker.box.appendChild(jscolor.picker.sldB);jscolor.picker.box.appendChild(jscolor.picker.sldM);jscolor.picker.padB.appendChild(jscolor.picker.pad);jscolor.picker.box.appendChild(jscolor.picker.padB);jscolor.picker.box.appendChild(jscolor.picker.padM);jscolor.picker.btnS.appendChild(jscolor.picker.btnT);jscolor.picker.btn.appendChild(jscolor.picker.btnS);jscolor.picker.box.appendChild(jscolor.picker.btn);jscolor.picker.boxB.appendChild(jscolor.picker.box)}var D=jscolor.picker;D.box.onmouseup=D.box.onmouseout=function(){A.focus()};D.box.onmousedown=function(){m=true};D.box.onmousemove=function(p){if(c||n){c&&v(p);n&&i(p);if(document.selection){document.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}f()}};D.padM.onmouseup=D.padM.onmouseout=function(){if(c){c=false;jscolor.fireEvent(a,"change")}};D.padM.onmousedown=function(p){switch(b){case 0:if(k.hsv[2]===0){k.fromHSV(null,null,1)}break;case 1:if(k.hsv[1]===0){k.fromHSV(null,1,null)}break}c=true;v(p);f()};D.sldM.onmouseup=D.sldM.onmouseout=function(){if(n){n=false;jscolor.fireEvent(a,"change")}};D.sldM.onmousedown=function(p){n=true;i(p);f()};var M=s(k);D.box.style.width=M[0]+"px";D.box.style.height=M[1]+"px";D.boxB.style.position="absolute";D.boxB.style.clear="both";D.boxB.style.left=K+"px";D.boxB.style.top=J+"px";D.boxB.style.zIndex=k.pickerZIndex;D.boxB.style.border=k.pickerBorder+"px solid";D.boxB.style.borderColor=k.pickerBorderColor;D.boxB.style.background=k.pickerFaceColor;D.pad.style.width=jscolor.images.pad[0]+"px";D.pad.style.height=jscolor.images.pad[1]+"px";D.padB.style.position="absolute";D.padB.style.left=k.pickerFace+"px";D.padB.style.top=k.pickerFace+"px";D.padB.style.border=k.pickerInset+"px solid";D.padB.style.borderColor=k.pickerInsetColor;D.padM.style.position="absolute";D.padM.style.left="0";D.padM.style.top="0";D.padM.style.width=k.pickerFace+2*k.pickerInset+jscolor.images.pad[0]+jscolor.images.arrow[0]+"px";D.padM.style.height=D.box.style.height;D.padM.style.cursor="crosshair";D.sld.style.overflow="hidden";D.sld.style.width=jscolor.images.sld[0]+"px";D.sld.style.height=jscolor.images.sld[1]+"px";D.sldB.style.display=k.slider?"block":"none";D.sldB.style.position="absolute";D.sldB.style.right=k.pickerFace+"px";D.sldB.style.top=k.pickerFace+"px";D.sldB.style.border=k.pickerInset+"px solid";D.sldB.style.borderColor=k.pickerInsetColor;D.sldM.style.display=k.slider?"block":"none";D.sldM.style.position="absolute";D.sldM.style.right="0";D.sldM.style.top="0";D.sldM.style.width=jscolor.images.sld[0]+jscolor.images.arrow[0]+k.pickerFace+2*k.pickerInset+"px";D.sldM.style.height=D.box.style.height;try{D.sldM.style.cursor="pointer"}catch(F){D.sldM.style.cursor="hand"}function L(){var p=k.pickerInsetColor.split(/\s+/);var N=p.length<2?p[0]:p[1]+" "+p[0]+" "+p[0]+" "+p[1];D.btn.style.borderColor=N}D.btn.style.display=k.pickerClosable?"block":"none";D.btn.style.position="absolute";D.btn.style.left=k.pickerFace+"px";D.btn.style.bottom=k.pickerFace+"px";D.btn.style.padding="0 15px";D.btn.style.height="18px";D.btn.style.border=k.pickerInset+"px solid";L();D.btn.style.color=k.pickerButtonColor;D.btn.style.font="12px sans-serif";D.btn.style.textAlign="center";try{D.btn.style.cursor="pointer"}catch(F){D.btn.style.cursor="hand"}D.btn.onmousedown=function(){k.hidePicker()};D.btnS.style.lineHeight=D.btn.style.height;switch(b){case 0:var E="hs.png";break;case 1:var E="hv.png";break}D.padM.style.backgroundImage="url('"+jscolor.getDir()+"cross.gif')";D.padM.style.backgroundRepeat="no-repeat";D.sldM.style.backgroundImage="url('"+jscolor.getDir()+"arrow.gif')";D.sldM.style.backgroundRepeat="no-repeat";D.pad.style.backgroundImage="url('"+jscolor.getDir()+E+"')";D.pad.style.backgroundRepeat="no-repeat";D.pad.style.backgroundPosition="0 0";q();z();jscolor.picker.owner=k;document.getElementsByTagName("body")[0].appendChild(D.boxB)}function s(D){var p=[2*D.pickerInset+2*D.pickerFace+jscolor.images.pad[0]+(D.slider?2*D.pickerInset+2*jscolor.images.arrow[0]+jscolor.images.sld[0]:0),D.pickerClosable?4*D.pickerInset+3*D.pickerFace+jscolor.images.pad[1]+D.pickerButtonHeight:2*D.pickerInset+2*D.pickerFace+jscolor.images.pad[1]];return p}function q(){switch(b){case 0:var F=1;break;case 1:var F=2;break}var J=Math.round((k.hsv[0]/6)*(jscolor.images.pad[0]-1));var I=Math.round((1-k.hsv[F])*(jscolor.images.pad[1]-1));jscolor.picker.padM.style.backgroundPosition=(k.pickerFace+k.pickerInset+J-Math.floor(jscolor.images.cross[0]/2))+"px "+(k.pickerFace+k.pickerInset+I-Math.floor(jscolor.images.cross[1]/2))+"px";var p=jscolor.picker.sld.childNodes;switch(b){case 0:var H=h(k.hsv[0],k.hsv[1],1);for(var D=0;D<p.length;D+=1){p[D].style.backgroundColor="rgb("+(H[0]*(1-D/p.length)*100)+"%,"+(H[1]*(1-D/p.length)*100)+"%,"+(H[2]*(1-D/p.length)*100)+"%)"}break;case 1:var H,K,G=[k.hsv[2],0,0];var D=Math.floor(k.hsv[0]);var E=D%2?k.hsv[0]-D:1-(k.hsv[0]-D);switch(D){case 6:case 0:H=[0,1,2];break;case 1:H=[1,0,2];break;case 2:H=[2,0,1];break;case 3:H=[2,1,0];break;case 4:H=[1,2,0];break;case 5:H=[0,2,1];break}for(var D=0;D<p.length;D+=1){K=1-1/(p.length-1)*D;G[1]=G[0]*(1-K*E);G[2]=G[0]*(1-K);p[D].style.backgroundColor="rgb("+(G[H[0]]*100)+"%,"+(G[H[1]]*100)+"%,"+(G[H[2]]*100)+"%)"}break}}function z(){switch(b){case 0:var p=2;break;case 1:var p=1;break}var D=Math.round((1-k.hsv[p])*(jscolor.images.sld[1]-1));jscolor.picker.sldM.style.backgroundPosition="0 "+(k.pickerFace+k.pickerInset+D-Math.floor(jscolor.images.arrow[1]/2))+"px"}function t(){return jscolor.picker&&jscolor.picker.owner===k}function o(){if(a===A){k.importColor()}if(k.pickerOnfocus){k.hidePicker()}}function l(){if(a!==A){k.importColor()}}function v(E){var D=jscolor.getRelMousePos(E);var p=D.x-k.pickerFace-k.pickerInset;var F=D.y-k.pickerFace-k.pickerInset;switch(b){case 0:k.fromHSV(p*(6/(jscolor.images.pad[0]-1)),1-F/(jscolor.images.pad[1]-1),null,e);break;case 1:k.fromHSV(p*(6/(jscolor.images.pad[0]-1)),null,1-F/(jscolor.images.pad[1]-1),e);break}}function i(D){var p=jscolor.getRelMousePos(D);var E=p.y-k.pickerFace-k.pickerInset;switch(b){case 0:k.fromHSV(null,null,1-E/(jscolor.images.sld[1]-1),u);break;case 1:k.fromHSV(null,1-E/(jscolor.images.sld[1]-1),null,u);break}}function f(){if(k.onImmediateChange){var p;if(typeof k.onImmediateChange==="string"){p=new Function(k.onImmediateChange)}else{p=k.onImmediateChange}p.call(k)}}var k=this;var b=this.pickerMode.toLowerCase()==="hvs"?1:0;var m=false;var a=jscolor.fetchElement(this.valueElement),C=jscolor.fetchElement(this.styleElement);var c=false,n=false;var w=1<<0,B=1<<1,u=1<<2,e=1<<3;jscolor.addEvent(A,"focus",function(){if(k.pickerOnfocus){k.showPicker()}});jscolor.addEvent(A,"blur",function(){if(!m){window.setTimeout(function(){m||o();m=false},0)}else{m=false}});if(a){var y=function(){k.fromString(a.value,w);f()};jscolor.addEvent(a,"keyup",y);jscolor.addEvent(a,"input",y);jscolor.addEvent(a,"blur",l);a.setAttribute("autocomplete","off")}if(C){C.jscStyle={backgroundImage:C.style.backgroundImage,backgroundColor:C.style.backgroundColor,color:C.style.color}}switch(b){case 0:jscolor.requireImage("hs.png");break;case 1:jscolor.requireImage("hv.png");break}jscolor.requireImage("cross.gif");jscolor.requireImage("arrow.gif");this.importColor()}};jscolor.install();