<?php
// module_slug, Module Title, Module Description, bootstrap WordPress?
class rb_malware_scan extends repairbuddy_module {
	var $_module_name = '';
	function __construct() {
		pb_add_action( 'init', array( &$this, 'init' ) );
	} //end constructor
	function init() {
		$args = array(
			'slug' => 'malware_scan',
			'title' => 'Malware Scan',
			'description' => 'Scan your site for malware or suspicious files.',
			'page' => 'view_malware',
			'bootstrap_wordpress' => true,
			'mini_mode' => false,
			'is_subtle' => '',
			'priority' => 20
		);
				
		$this->_module_name = $args[ 'slug' ];
		pb_register_module( $args );
		
		//Actions
		$action = sprintf( 'pb_loadpage_%s_%s', $args[ 'slug' ], $args[ 'page' ] );
		pb_add_action( $action , array( &$this, 'display_page' ) );
	} //end init
	
	function display_page() {
		//Need WP to load
		if ( !defined( 'PB_WP_LOADED' ) ) {
			global $pluginbuddy_repairbuddy;
			$pluginbuddy_repairbuddy->output_status( "WordPress is required for this functionality.  Please make sure RepairBuddy is placed at the root of your WordPress install.", true );
		} else {

			$page = $this->get_plugin_dir( 'pages/view_malware.php', __FILE__ );
			
			if ( !file_exists( $page ) ) {
				?>
				<h2>Could not load page</h2>
				<?php
			} else {
				global $pluginbuddy_repairbuddy;
				$parent_class = $pluginbuddy_repairbuddy;
				require_once( $page );
			}
		}
	} //end display_page
	
} //end class
$rb_malware_scan = new rb_malware_scan();
?>